####################################################
### code chunk number : Simulations: Marginal density, mu0 = 3, k0 = 1, v0 = 6, sigma0 = 1
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = 3; mu0    ## hyperparameter
k0 = 1          ## hyperparameter
v0 = 6; v0      ## hyperparameter
sigma0 = 1      ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0

x = seq(-2, 8, by = 0.01)
md = Marginal_density_hyperparameters(x, mu0, k0, v0, sigma0)

dev.new()
col = 1:1
lty = 1:1
xlim = range(x); xlim
ylim = c(0, 0.4); ylim
plot(x, md, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md,  lty = lty[1], col = col[1], lwd = 4)
# title(Title)
leg.txt = "mu0 = 3, k0 = 1, v0 = 6, sigma0 = 1"
legend("topright", legend = leg.txt, lty = lty, col = col)
# savePlot(filename = paste("figure/md_x", sep=""), type = c("pdf"))


####################################################
### code chunk number : Simulations: Marginal density, mu0 changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = c(-3, 0, 3, 6, 9); mu0    ## hyperparameter
k0 = 1                          ## hyperparameter
v0 = 6; v0                      ## hyperparameter
sigma0 = 1                      ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0

x = seq(-7, 15, by = 0.01)
md1 = Marginal_density_hyperparameters(x, mu0 = mu0[1], k0, v0, sigma0); 
md2 = Marginal_density_hyperparameters(x, mu0 = mu0[2], k0, v0, sigma0);
md3 = Marginal_density_hyperparameters(x, mu0 = mu0[3], k0, v0, sigma0); 
md4 = Marginal_density_hyperparameters(x, mu0 = mu0[4], k0, v0, sigma0); 
md5 = Marginal_density_hyperparameters(x, mu0 = mu0[5], k0, v0, sigma0); 

dev.new()
col = 1:5
lty = 1:5
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4, md5); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 4)
lines(x, md5,  lty = lty[5], col = col[5], lwd = 4)
# title(Title)
leg.txt = c(
expression(paste(mu[0], " = -3", sep = "")),
expression(paste(mu[0], " = 0", sep = "")),
expression(paste(mu[0], " = 3", sep = "")),
expression(paste(mu[0], " = 6", sep = "")),
expression(paste(mu[0], " = 9", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/N-NIG_md_x_mu0_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/N-NIG_md_x_mu0_changes", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal density, k0 changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = 3; mu0                ## hyperparameter
k0 = c(0.25, 0.5, 1, 2, 4)  ## hyperparameter
v0 = 6; v0                  ## hyperparameter
sigma0 = 1                  ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0

x = seq(-2, 8, by = 0.01)
md1 = Marginal_density_hyperparameters(x, mu0, k0 = k0[1], v0, sigma0); 
md2 = Marginal_density_hyperparameters(x, mu0, k0 = k0[2], v0, sigma0); 
md3 = Marginal_density_hyperparameters(x, mu0, k0 = k0[3], v0, sigma0);  
md4 = Marginal_density_hyperparameters(x, mu0, k0 = k0[4], v0, sigma0);  
md5 = Marginal_density_hyperparameters(x, mu0, k0 = k0[5], v0, sigma0);   

dev.new()
col = 1:5
lty = 1:5
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4, md5); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 4)
lines(x, md5,  lty = lty[5], col = col[5], lwd = 4)
# title(Title)
leg.txt = c(
expression(paste(kappa[0], " = 0.25", sep = "")),
expression(paste(kappa[0], " = 0.5", sep = "")),
expression(paste(kappa[0], " = 1", sep = "")),
expression(paste(kappa[0], " = 2", sep = "")),
expression(paste(kappa[0], " = 4", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/N-NIG_md_x_k0_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/N-NIG_md_x_k0_changes", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal density, v0 changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = 3; mu0                    ## hyperparameter
k0 = 1                          ## hyperparameter
v0 = c(2, 4, 6, 12, 24); v0      ## hyperparameter
sigma0 = 1                      ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0

x = seq(-2, 8, by = 0.01)
md1 = Marginal_density_hyperparameters(x, mu0, k0, v0 = v0[1], sigma0); 
md2 = Marginal_density_hyperparameters(x, mu0, k0, v0 = v0[2], sigma0); 
md3 = Marginal_density_hyperparameters(x, mu0, k0, v0 = v0[3], sigma0);  
md4 = Marginal_density_hyperparameters(x, mu0, k0, v0 = v0[4], sigma0);  
md5 = Marginal_density_hyperparameters(x, mu0, k0, v0 = v0[5], sigma0);   

dev.new()
col = 1:5
lty = 1:5
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4, md5); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 4)
lines(x, md5,  lty = lty[5], col = col[5], lwd = 4)
# title(Title)
leg.txt = c(
expression(paste(nu[0], " = 2", sep = "")),
expression(paste(nu[0], " = 4", sep = "")),
expression(paste(nu[0], " = 6", sep = "")),
expression(paste(nu[0], " = 12", sep = "")),
expression(paste(nu[0], " = 24", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/N-NIG_md_x_v0_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/N-NIG_md_x_v0_changes", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal density, simga0 changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = 3; mu0                              ## hyperparameter
k0 = 1                                    ## hyperparameter
v0 = 6; v0                                ## hyperparameter
sigma0 = sqrt(c(0.25, 0.5, 1, 2, 4))      ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0

x = seq(-2, 8, by = 0.01)
md1 = Marginal_density_hyperparameters(x, mu0, k0, v0, sigma0 = sigma0[1]); 
md2 = Marginal_density_hyperparameters(x, mu0, k0, v0, sigma0 = sigma0[2]); 
md3 = Marginal_density_hyperparameters(x, mu0, k0, v0, sigma0 = sigma0[3]);  
md4 = Marginal_density_hyperparameters(x, mu0, k0, v0, sigma0 = sigma0[4]);  
md5 = Marginal_density_hyperparameters(x, mu0, k0, v0, sigma0 = sigma0[5]);   

dev.new()
col = 1:5
lty = 1:5
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4, md5); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 4)
lines(x, md5,  lty = lty[5], col = col[5], lwd = 4)
# title(Title)
leg.txt = c(
expression(paste(sigma[0]^2, " = 0.25", sep = "")),
expression(paste(sigma[0]^2, " = 0.5", sep = "")),
expression(paste(sigma[0]^2, " = 1", sep = "")),
expression(paste(sigma[0]^2, " = 2", sep = "")),
expression(paste(sigma[0]^2, " = 4", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/N-NIG_md_x_simga0_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/N-NIG_md_x_simga0_changes", sep=""), type = c("jpg"))


